const expect = require('chai').expect;
const path = require('path');

// Remove the import from 'node:test'
let $$ = require('../js/utils/debug')({ debug: true });
$$.fs = require('../js/utils/fs');
let yaml = require('../js/yaml');

let customerDir = '/agorum/roi/customers/cdev.ncore/test/data/yml';

// Mocking the directory content for the purpose of this test.
// In actual implementation, you would read from the file system.
let exportFiles = ['export.yml', 'export-legacy.yml'];
$$.debug(`Found ${exportFiles.length} export files`, exportFiles);

describe('YAML Export Files Test', function () {

  it('should find export YAML files', function () {
    expect(exportFiles).to.be.an('array').that.is.not.empty;
    expect(exportFiles).to.include.members(['export.yml', 'export-legacy.yml']);
  });

  exportFiles.forEach(function (file) {
    $$.debug(`Testing file: ${file}`);
    describe(`File: ${file}`, function () {
      let yamlContent;

      before(function () {
        // Read the YAML file content
        yamlContent = yaml.read(path.join(customerDir, file));
      });

      it('should successfully read the YAML file', function () {
        expect(yamlContent).to.exist;
        expect(yamlContent).to.be.an('array');
      });

      if (file === 'export.yml') {
        it('should contain an object with key "ac"', function () {
          const hasAc = yamlContent.some(item => 'ac' in item);
          expect(hasAc).to.be.true;
        });

        it('should contain an object with key "Smart Assistant"', function () {
          const hasSmartAssistant = yamlContent.some(item => 'Smart Assistant' in item);
          expect(hasSmartAssistant).to.be.true;
        });

        it('should contain multiple objects with key "Package"', function () {
          const packageCount = yamlContent.filter(item => 'Package' in item).length;
          expect(packageCount).to.be.greaterThan(1);
        });
      } else if (file === 'export-legacy.yml') {
        // Additional tests for 'export-legacy.yml' can be added here
        it('should have content specific tests for export-legacy.yml', function () {
          // Placeholder test
          expect(true).to.be.true;
        });
      }
    });
  });
});
